# gameplay items
data modify storage main:item id.SMALL_MUSHROOM set value {components: {"minecraft:item_name": {"translate":"item.purple.small_mushroom","fallback":"Shrink 'Shroom"}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:use_remainder": {count: 1, components: {"minecraft:item_name": "", "minecraft:tooltip_display": {"hide_tooltip": true}, "minecraft:item_model": "minecraft:air", "minecraft:max_stack_size": 1, "minecraft:custom_data": {id: "SMALL_MUSHROOM_ABILITY"}}, id: "minecraft:red_mushroom"}, "minecraft:consumable": {consume_seconds: 0.5f}, "minecraft:profile": {properties: [{name: "textures", value: "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmY5NmI4ZDAxZjU4MzVlZDM4YWZkNDUzMDIyOGQwYjVhYmI3ZDQ1YTM1NTUxOWVhNjgwYzQwZmZjYTMyZWRmMiJ9fX0="}]}, "minecraft:custom_data": {id: "SMALL_MUSHROOM"}, "!minecraft:equippable": {}}, count: 1, id: "minecraft:player_head"}
data modify storage main:item id.CHORUS_FRUIT set value {components: {"minecraft:item_name": {"translate":"item.purple.chorus_fruit","fallback":"Instant Chorus Fruit"}, "minecraft:max_stack_size": 9, "minecraft:rarity": "common", "minecraft:use_cooldown": {seconds: 1.0f, cooldown_group: "purple:chorus_fruit"}, "minecraft:consumable": {on_consume_effects: [{diameter: 32.0f, type: "minecraft:teleport_randomly"}], consume_seconds: 0.05f}, "minecraft:custom_data": {id: "CHORUS_FRUIT"}}, count: 3, id: "minecraft:chorus_fruit"}
data modify storage main:item id.ENDER_PEARL set value {components: {"minecraft:item_name": {"translate":"item.purple.ender_pearl","fallback":"Ender Pearl"}, "minecraft:max_stack_size": 3, "minecraft:rarity": "common", "minecraft:custom_data": {id: "ENDER_PEARL"}}, count: 1, id: "minecraft:ender_pearl"}
data modify storage main:item id.GLOW_HORN set value {components: {"minecraft:item_name": {"translate":"item.purple.glow_horn","fallback":"Glow Horn"}, "minecraft:lore": [{"translate":"item.purple.glow_horn.desc","fallback":"Reveal all players","color":"gray","italic":false}], "minecraft:instrument": "minecraft:sing_goat_horn", "minecraft:max_stack_size": 5, "minecraft:rarity": "common", "minecraft:custom_data": {id: "GLOW_HORN"}, "minecraft:tooltip_display": {"hidden_components": ["minecraft:instrument"]}}, count: 1, id: "minecraft:goat_horn"}
data modify storage main:item id.TOTEM_OF_UNDYING set value {components: {"minecraft:item_name": {"translate":"item.purple.totem_of_undying","fallback":"Totem of Undying"}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:custom_data": {id: "TOTEM_OF_UNDYING"}}, count: 1, id: "minecraft:totem_of_undying"}
data modify storage main:item id.TRIDENT set value {components: {"minecraft:item_name": {"translate":"item.purple.trident","fallback":"Trident"}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:custom_data": {id: "TRIDENT"}, "minecraft:max_damage": 2, "!minecraft:attribute_modifiers": {}}, count: 1, id: "minecraft:trident"}
data modify storage main:item id.SAFETY_VEST set value {components: {"minecraft:item_name": {"translate":"item.purple.safety_vest","fallback":"Safety Vest"}, "minecraft:lore": [{"translate":"item.purple.safety_vest.desc","fallback":"Block one hit","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:custom_data": {id: "SAFETY_VEST"}, "minecraft:max_damage": 2, "minecraft:trim": {material: "minecraft:iron", pattern: "minecraft:host"}, "minecraft:dyed_color": 16742400, "minecraft:tooltip_display": {"hidden_components": ["minecraft:trim","minecraft:dyed_color"]}, "!minecraft:attribute_modifiers": {}}, count: 1, id: "minecraft:leather_chestplate"}
data modify storage main:item id.PRISON_KEY set value {components: {"minecraft:item_name": {"translate":"item.purple.prison_key","fallback":"Prison Key"}, "minecraft:lore": [{"translate":"item.purple.prison_key.desc","fallback":"Hit someone to imprison them","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:custom_data": {id: "PRISON_KEY"}}, count: 1, id: "minecraft:trial_key"}
data modify storage main:item id.COMPASS set value {components: {"minecraft:item_name": {"translate":"item.purple.compass","fallback":"Tracking Compass"}, "minecraft:custom_name": {"translate":"item.purple.compass","fallback":"Tracking Compass","italic":false}, "minecraft:lore": [{"translate":"item.purple.compass.desc","fallback":"Track the nearest player","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:use_cooldown": {seconds: 0.5f, cooldown_group: "purple:compass"}, "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:damage": 0, "minecraft:lodestone_tracker": {tracked: 0b, target: {pos: [I; 0, 0, 0], dimension: "missing:no"}}, "minecraft:enchantment_glint_override": 0b, "minecraft:custom_data": {id: "COMPASS"}, "minecraft:max_damage": 4}, count: 1, id: "minecraft:compass"}
data modify storage main:item id.FREEZE_TIME set value {components: {"minecraft:item_name": {"translate":"item.purple.freeze_time","fallback":"Freeze Timer"}, "minecraft:lore": [{"translate":"item.purple.freeze_time.desc","fallback":"Freeze time for %ss","with":["5"],"color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "FREEZE_TIME"}}, count: 1, id: "minecraft:clock"}
data modify storage main:item id.SMOKE_BOMB set value {components: {"minecraft:item_name": {"translate":"item.purple.smoke_bomb","fallback":"Smoke Bomb"}, "minecraft:custom_name": {"translate":"item.purple.smoke_bomb","fallback":"Smoke Bomb","italic":false}, "minecraft:max_stack_size": 3, "minecraft:rarity": "common", "minecraft:custom_data": {id: "SMOKE_BOMB"}, "minecraft:tooltip_display": {"hidden_components": ["minecraft:potion_contents"]}, "minecraft:potion_contents": {custom_effects: [{duration: 10, amplifier: 50b, ambient: 1b, show_icon: 0b, id: "minecraft:invisibility", show_particles: 0b}], custom_color: 7829367}}, count: 1, id: "minecraft:lingering_potion"}
data modify storage main:item id.ANTIDOTE set value {components: {"minecraft:item_name": {"translate":"item.purple.antidote","fallback":"Antidote"}, "minecraft:custom_name": {"translate":"item.purple.antidote","fallback":"Antidote","italic":false}, "minecraft:lore": [{"translate":"item.purple.antidote.desc","fallback":"Cure yourself","color":"gray","italic":false}], "minecraft:max_stack_size": 3, "minecraft:rarity": "common", "minecraft:custom_data": {id: "ANTIDOTE"}, "minecraft:tooltip_display": {"hidden_components": ["minecraft:potion_contents"]}, "minecraft:potion_contents": {custom_color: 16711680}}, count: 1, id: "minecraft:potion"}
data modify storage main:item id.WIND_CHARGE set value {components: {"minecraft:item_name": {"fallback":"Wind Charge","translate":"item.purple.wind_charge"}, "minecraft:max_stack_size": 10, "minecraft:rarity": "common", "minecraft:custom_data": {id: "WIND_CHARGE"}}, count: 5, id: "minecraft:wind_charge"}
data modify storage main:item id.REVIVAL_POTION set value {components: {"minecraft:item_name": {"fallback":"Revival Elixer","translate":"item.purple.revival_potion"}, "minecraft:custom_name": {"fallback":"Revival Elixer","translate":"item.purple.revival_potion","italic":false}, "minecraft:lore": [{"translate":"item.purple.revival_potion.desc.1","fallback":"Splash a dead player","color":"gray","italic":false},{"translate":"item.purple.revival_potion.desc.2","fallback":"to revive them","color":"gray","italic":false}], "minecraft:max_stack_size": 3, "minecraft:rarity": "common", "minecraft:item_model": "minecraft:splash_potion", "minecraft:custom_data": {id: "REVIVAL_POTION"}, "minecraft:tooltip_display": {"hidden_components": ["minecraft:potion_contents"]}, "minecraft:potion_contents": {custom_effects: [{duration: 10000, amplifier: -1b, show_icon: 0b, id: "minecraft:regeneration", show_particles: 0b}], custom_color: 16768256}}, count: 1, id: "minecraft:lingering_potion"}
data modify storage main:item id.DECOY set value {components: {"minecraft:item_name": {"translate":"item.purple.decoy","fallback":"Decoy"}, "minecraft:lore": [{"translate":"item.purple.decoy.desc","fallback":"Create a decoy of yourself","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:can_place_on":{}, "minecraft:tooltip_display":{hidden_components:["minecraft:can_place_on"]}, "minecraft:custom_data": {id: "DECOY"}, "minecraft:item_model":"minecraft:armor_stand", "minecraft:entity_data": {id:"minecraft:villager",Silent:1b,CanPickUpLoot:0b,AbsorptionAmount:1024f,Health:1024f,Tags:["new_decoy","decoy","decoy_entity"],active_effects:[{id:"minecraft:invisibility",amplifier:255,duration:-1,show_particles:0b}],attributes:[{id:"minecraft:max_absorption",base:1024},{id:"minecraft:max_health",base:1024},{id:"minecraft:scale",base:0.75}],team:'hide_nametag',VillagerData:{profession:"minecraft:nitwit",type:"minecraft:plains"},Offers:{}}}, count: 1, id: "minecraft:villager_spawn_egg"}

# miscellaneous items
data modify storage main:item id.READY set value {components: {"minecraft:item_name": {"bold":true,"color":"green","translate":"item.purple.ready","fallback":"Click to Ready-up!"}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "READY"}}, count: 1, id: "minecraft:red_dye"}
data modify storage main:item id.NOT_READY set value {components: {"minecraft:item_name": {"bold":true,"color":"red","translate":"item.purple.not_ready","fallback":"Click to Cancel"}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "NOT_READY"}}, count: 1, id: "minecraft:lime_dye"}
data modify storage main:item id.LOBBY set value {components: {"minecraft:item_name": {"translate":"item.purple.lobby","fallback":"Click to return to Base Camp","color":"red","bold":true}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:item_model": "minecraft:arrow", "minecraft:use_cooldown": {seconds: 0.5f, cooldown_group: "purple:lobby"}, "minecraft:instrument": {"use_duration": 0.05, "range": 1, "sound_event": {"sound_id": "minecraft:intentionally_empty"}, "description": ""}, "minecraft:custom_data": {id: "LOBBY"}, "minecraft:tooltip_display": {"hidden_components": ["instrument"]}}, count: 1, id: "minecraft:goat_horn"}
data modify storage main:item id.SPECTATE set value {components: {"minecraft:item_name": {"translate":"item.purple.spectate","fallback":"Click to enter Spectator Mode","color":"dark_purple","bold":true}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:item_model": "minecraft:ender_eye", "minecraft:use_cooldown": {seconds: 0.5f, cooldown_group: "purple:spectate"}, "minecraft:instrument": {"use_duration": 0.05, "range": 1, "sound_event": {"sound_id": "minecraft:intentionally_empty"}, "description": ""}, "minecraft:custom_data": {id: "SPECTATE"}, "minecraft:tooltip_display": {"hidden_components": ["instrument"]}}, count: 1, id: "minecraft:goat_horn"}
data modify storage main:item id.SPECTATE_GAME set value {components: {"minecraft:item_name": {"translate":"item.purple.spectate_game","fallback":"Click to Spectate the Game","color":"dark_purple","bold":true}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:item_model": "minecraft:ender_eye", "minecraft:use_cooldown": {seconds: 0.5f, cooldown_group: "purple:spectate"}, "minecraft:instrument": {"use_duration": 0.05, "range": 1, "sound_event": {"sound_id": "minecraft:intentionally_empty"}, "description": ""}, "minecraft:custom_data": {id: "SPECTATE_GAME"}, "minecraft:tooltip_display": {"hidden_components": ["instrument"]}}, count: 1, id: "minecraft:goat_horn"}

# The Purple
data modify storage main:item id.SOURCE set value {components: {"minecraft:item_name": {"translate":"item.purple.source","fallback":"%s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_ABILITY_1 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.source_ability.speed","fallback":"Speed Burst","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.source_ability.speed.desc.1","fallback":"Gain a burst of Speed IV","color":"gray","italic":false},{"translate":"setting.purple.button.source_ability.speed.desc.2","fallback":"for %s seconds","with":["5"],"color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_ABILITY_2 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.source_ability.invisible","fallback":"Invisibility","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.source_ability.invisible.desc.1","fallback":"Become Invisible","color":"gray","italic":false},{"translate":"setting.purple.button.source_ability.invisible.desc.2","fallback":"for %s seconds","with":["20"],"color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_ABILITY_3 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.source_ability.darkness","fallback":"Looming Darkness","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.source_ability.darkness.desc.1","fallback":"Inflict Darkness on everyone","color":"gray","italic":false},{"translate":"setting.purple.button.source_ability.darkness.desc.2","fallback":"else for %s seconds","with":["10"],"color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_ABILITY_4 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.source_ability.corruption","fallback":"Corrupt Growth","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.source_ability.corruption.desc.1","fallback":"Spread corrupt blocks around","color":"gray","italic":false},{"translate":"setting.purple.button.source_ability.corruption.desc.2","fallback":"yourself and %s nearby","with":["2"],"color":"gray","italic":false},{"translate":"setting.purple.button.source_ability.corruption.desc.3","fallback":"players for %s seconds","with":["5"],"color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_ABILITY_5 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.source_ability.reach","fallback":"Long Arms","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.source_ability.reach.desc.1","fallback":"Doubles your reach","color":"gray","italic":false},{"translate":"setting.purple.button.source_ability.reach.desc.2","fallback":"for %s seconds","with":["10"],"color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_ABILITY_6 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.source_ability.clone","fallback":"Clone Ally","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.source_ability.clone.desc.1","fallback":"Create a clone","color":"gray","italic":false},{"translate":"setting.purple.button.source_ability.clone.desc.2","fallback":"of yourself","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_SPECTATOR_1 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.spectator_ability.fireworks","fallback":"Fireworks","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.spectator_ability.fireworks.desc.1","fallback":"Launch fireworks above","color":"gray","italic":false},{"translate":"setting.purple.button.spectator_ability.fireworks.desc.2","fallback":"the nearest player","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_SPECTATOR_2 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.spectator_ability.speed","fallback":"Speed Burst","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.spectator_ability.speed.desc.1","fallback":"Grant a burst of speed","color":"gray","italic":false},{"translate":"setting.purple.button.spectator_ability.speed.desc.2","fallback":"to every player","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_SPECTATOR_3 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.spectator_ability.teleport","fallback":"Random Teleport","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.spectator_ability.teleport.desc.1","fallback":"Teleport a random player to","color":"gray","italic":false},{"translate":"setting.purple.button.spectator_ability.teleport.desc.2","fallback":"the player closest to you","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_SPECTATOR_4 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.spectator_ability.slime","fallback":"Slime Swarm","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.spectator_ability.slime.desc.1","fallback":"Spawn multiple slimes on top","color":"gray","italic":false},{"translate":"setting.purple.button.spectator_ability.slime.desc.2","fallback":"of the nearest player","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_SPECTATOR_5 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.spectator_ability.time","fallback":"Reduce Timer","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.spectator_ability.time.desc","fallback":"Cut the remaining time in half","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}
data modify storage main:item id.SOURCE_SPECTATOR_6 set value {components: {"minecraft:item_name": {"translate":"item.purple.source.ability","fallback":"%2$s - %s","with":[{"translate":"item.purple.spectator_ability.item","fallback":"Item Box","color":"green"},[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]],"color":"dark_gray"}, "minecraft:lore": [{"translate":"setting.purple.button.spectator_ability.item.desc.1","fallback":"Spawn a random item on the","color":"gray","italic":false},{"translate":"setting.purple.button.spectator_ability.item.desc.2","fallback":"ground in front of you","color":"gray","italic":false}], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "THE_PURPLE"}}, count: 1, id: "minecraft:popped_chorus_fruit"}

data modify storage main:item id.EDIBLE_HORSE set value {components: {"!minecraft:attribute_modifiers": {}, "minecraft:item_name": {"fallback":"Horse","translate":"entity.minecraft.horse"}, "minecraft:lore": [{"color":"gray","fallback":"How hungry?","italic":false,"translate":"item.purple.edible_horse"}], "minecraft:food": {saturation: 20.0f, nutrition: 20, can_always_eat: 1b}, "minecraft:consumable": {on_consume_effects: [{type: "minecraft:play_sound", sound: "minecraft:entity.horse.death"}], consume_seconds: 1.0f}, "minecraft:profile": {properties: [{name: "textures", value: "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTMzNWUzMTk2MTcxMzM1M2E3NjQwMWUwMGMzNDU0YjdjYTg4NWI3Nzg0ZDUyODhkMzIyNzIyMmQ5YjQ4ZDM5MyJ9fX0="}]}, "minecraft:custom_data": {id: "EDIBLE_HORSE"}}, count: 1, id: "minecraft:player_head"}
data modify storage main:item id.KNOCKBACK_SLIMEBALL set value {components: {"minecraft:item_name": {"fallback":"Yeet!","translate":"item.purple.knockback_slimeball"}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:enchantments": {levels: {"minecraft:knockback": 10}}, "minecraft:custom_data": {id: "KNOCKBACK_SLIMEBALL"}}, count: 1, id: "minecraft:slime_ball"}
data modify storage main:item id.SHARP_PUFFERFISH set value {components: {"minecraft:item_name": {"fallback":"Ouch!","translate":"item.purple.sharp_pufferfish"}, "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:enchantments": {levels: {"minecraft:sharpness": 100}}, "minecraft:custom_data": {id: "SHARP_PUFFERFISH"}, "!minecraft:consumable": {}}, count: 1, id: "minecraft:pufferfish"}
data modify storage main:item id.TRANSLATE_BOOK set value {components: {"minecraft:item_name": {"translate":"item.purple.translate_book","fallback":"Translate Book"}, "minecraft:max_stack_size": 1, "minecraft:rarity": "rare", "minecraft:custom_data": {id: "TRANSLATE_BOOK"}}, count: 1, id: "minecraft:writable_book"}

data modify storage main:item id.ROCK set value {components: {"minecraft:item_name": {"fallback":"Rock","translate":"item.purple.rock"}, "minecraft:max_stack_size": 99, "!minecraft:equippable": {}, "minecraft:profile": {properties: [{name: "textures", value: "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjQxZjhiYTViNDZiZDY4MjVkYWNlNzA0MjgzZjFhMTZjZGY5OTI0ZTlkZTVjYmNlNzM1NDQ1YWZjNzZhNTZlIn19fQ=="}]}, "minecraft:damage_resistant": {types: "#minecraft:on_fire"}, "minecraft:custom_data": {id: "ROCK"}, "minecraft:use_cooldown": {seconds: 0.125f, cooldown_group: "purple:rock"}, "minecraft:consumable": {consume_seconds: 0.0f, has_consume_particles: 0b, on_consume_effects: [{type: "minecraft:play_sound", sound: "minecraft:entity.witch.throw"}], sound: "minecraft:intentionally_empty", animation: "block"}}, count: 1, id: "minecraft:player_head"}
data modify storage main:item id.THROWING_ROCK set value {components: {"minecraft:item_name": {"fallback":"Rock","translate":"item.purple.rock"}, "minecraft:max_stack_size": 99, "!minecraft:equippable": {}, "minecraft:profile": {properties: [{name: "textures", value: "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjQxZjhiYTViNDZiZDY4MjVkYWNlNzA0MjgzZjFhMTZjZGY5OTI0ZTlkZTVjYmNlNzM1NDQ1YWZjNzZhNTZlIn19fQ=="}]}, "minecraft:damage_resistant": {types: "#minecraft:on_fire"}, "minecraft:custom_data": {id: "ROCK"}, "minecraft:use_cooldown": {seconds: 0.125f, cooldown_group: "purple:rock"}, "minecraft:consumable": {consume_seconds: 0.0f, has_consume_particles: 0b, on_consume_effects: [{type: "minecraft:play_sound", sound: "minecraft:entity.witch.throw"}], sound: "minecraft:intentionally_empty", animation: "block"}}, count: 1, id: "minecraft:player_head"}
data modify storage main:item id.EDIBLE_ROCK set value {components: {"minecraft:item_name": {"fallback":"Rock","translate":"item.purple.rock"}, "minecraft:max_stack_size": 99, "!minecraft:equippable": {}, "minecraft:profile": {properties: [{name: "textures", value: "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjQxZjhiYTViNDZiZDY4MjVkYWNlNzA0MjgzZjFhMTZjZGY5OTI0ZTlkZTVjYmNlNzM1NDQ1YWZjNzZhNTZlIn19fQ=="}]}, "minecraft:damage_resistant": {types: "#minecraft:on_fire"}, "minecraft:custom_data": {id: "EDIBLE_ROCK"}, "minecraft:use_cooldown": {seconds: 0.125f, cooldown_group: "purple:rock"}, "minecraft:consumable": {consume_seconds: 2.0f, has_consume_particles: 1b, on_consume_effects: [{type: "minecraft:play_sound", sound: "minecraft:entity.player.burp"}], sound: "minecraft:entity.generic.eat", animation: "eat"}}, count: 1, id: "minecraft:player_head"}
data modify storage main:item id.RANDOM_ROCK set value {components: {"minecraft:item_name": {"fallback":"Rock","translate":"item.purple.rock"}, "minecraft:max_stack_size": 99, "!minecraft:equippable": {}, "minecraft:profile": {properties: [{name: "textures", value: "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjQxZjhiYTViNDZiZDY4MjVkYWNlNzA0MjgzZjFhMTZjZGY5OTI0ZTlkZTVjYmNlNzM1NDQ1YWZjNzZhNTZlIn19fQ=="}]}, "minecraft:damage_resistant": {types: "#minecraft:on_fire"}, "minecraft:custom_data": {id: "ROCK"}, "minecraft:use_cooldown": {seconds: 0.125f, cooldown_group: "purple:rock"}, "minecraft:consumable": {consume_seconds: 0.0f, has_consume_particles: 0b, on_consume_effects: [{type: "minecraft:play_sound", sound: "minecraft:entity.witch.throw"}], sound: "minecraft:intentionally_empty", animation: "block"}}, count: 1, id: "minecraft:player_head"}
data modify storage main:item id.GAME_ROCK set value {components: {"minecraft:item_name": {"fallback":"Rock","translate":"item.purple.rock"}, "minecraft:max_stack_size": 15, "!minecraft:equippable": {}, "minecraft:profile": {properties: [{name: "textures", value: "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjQxZjhiYTViNDZiZDY4MjVkYWNlNzA0MjgzZjFhMTZjZGY5OTI0ZTlkZTVjYmNlNzM1NDQ1YWZjNzZhNTZlIn19fQ=="}]}, "minecraft:damage_resistant": {types: "#minecraft:on_fire"}, "minecraft:custom_data": {id: "GAME_ROCK"}, "minecraft:use_cooldown": {seconds: 0.125f, cooldown_group: "purple:rock"}, "minecraft:consumable": {consume_seconds: 0.0f, has_consume_particles: 0b, on_consume_effects: [{type: "minecraft:play_sound", sound: "minecraft:entity.witch.throw"}], sound: "minecraft:intentionally_empty", animation: "block"}}, count: 5, id: "minecraft:player_head"}

# source ability
data modify storage main:item id.SOURCE_ABILITY_SPEED set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.source_ability","fallback":"Infected Ability: %s","with":[{"color":"white","translate":"item.purple.source_ability.speed","fallback":"Speed Burst"}]}, "minecraft:custom_name": {"color":"green","italic":false,"translate":"item.purple.source_ability","fallback":"Infected Ability: %s","with":[{"color":"white","translate":"item.purple.source_ability.speed","fallback":"Speed Burst"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.source.0","fallback":"When Infected:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[20]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "SOURCE_ABILITY"}, "minecraft:tooltip_display": {"hidden_components": ["minecraft:potion_contents"]}, "minecraft:potion_contents": {custom_color: 61183}}, count: 1, id: "minecraft:potion"}
data modify storage main:item id.SOURCE_ABILITY_INVISIBLE set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.source_ability","fallback":"Infected Ability: %s","with":[{"color":"white","translate":"item.purple.source_ability.invisible","fallback":"Invisibility"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.source.0","fallback":"When Infected:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[20]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "SOURCE_ABILITY"}}, count: 1, id: "minecraft:glass"}
data modify storage main:item id.SOURCE_ABILITY_DARKNESS set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.source_ability","fallback":"Infected Ability: %s","with":[{"color":"white","translate":"item.purple.source_ability.darkness","fallback":"Looming Darkness"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.source.0","fallback":"When Infected:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[20]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:food": {nutrition:0, saturation:0, can_always_eat:1b}, "minecraft:custom_data": {id: "SOURCE_ABILITY"}}, count: 1, id: "minecraft:dried_kelp"}
data modify storage main:item id.SOURCE_ABILITY_CORRUPTION set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.source_ability","fallback":"Infected Ability: %s","with":[{"color":"white","translate":"item.purple.source_ability.corruption","fallback":"Corrupt Growth"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.source.0","fallback":"When Infected:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[20]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "SOURCE_ABILITY"}}, count: 1, id: "minecraft:chorus_plant"}
data modify storage main:item id.SOURCE_ABILITY_REACH set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.source_ability","fallback":"Infected Ability: %s","with":[{"color":"white","translate":"item.purple.source_ability.reach","fallback":"Long Arms"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.source.0","fallback":"When Infected:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[20]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "SOURCE_ABILITY"}}, count: 1, id: "minecraft:echo_shard"}
data modify storage main:item id.SOURCE_ABILITY_CLONE set value {components: {"minecraft:custom_name": {"italic":false, "color":"green","translate":"item.purple.source_ability","fallback":"Infected Ability: %s","with":[{"color":"white","translate":"item.purple.source_ability.clone","fallback":"Clone Ally"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.source.0","fallback":"When Infected:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.source.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[20]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "SOURCE_ABILITY"}, "!minecraft:equippable": {}}, count: 1, id: "minecraft:player_head"}

# spectator ability
data modify storage main:item id.SPECTATOR_ABILITY_FIREWORKS set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.spectator_ability","fallback":"Spectator Ability: %s","with":[{"color":"white","translate":"item.purple.spectator_ability.fireworks","fallback":"Fireworks"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.corrupted.0","fallback":"When Dead:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.spectator.0","fallback":"When in Spectator Mode:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.1","fallback":"Punch the air to"}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.2","fallback":"use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[15]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "!minecraft:fireworks": {}, "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:item_model": "minecraft:firework_rocket", "minecraft:custom_data": {id: "SPECTATOR_ABILITY"}}, count: 1, id: "minecraft:stick"}
data modify storage main:item id.SPECTATOR_ABILITY_SPEED set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.spectator_ability","fallback":"Spectator Ability: %s","with":[{"color":"white","translate":"item.purple.spectator_ability.speed","fallback":"Speed Burst"}]}, "minecraft:custom_name": {"color":"green","italic":false,"translate":"item.purple.spectator_ability","fallback":"Spectator Ability: %s","with":[{"color":"white","translate":"item.purple.spectator_ability.speed","fallback":"Speed Burst"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.corrupted.0","fallback":"When Dead:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.spectator.0","fallback":"When in Spectator Mode:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.1","fallback":"Punch the air to"}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.2","fallback":"use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[15]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "SPECTATOR_ABILITY"}, "minecraft:tooltip_display": {"hidden_components": ["minecraft:potion_contents"]}, "minecraft:potion_contents": {custom_color: 61183}}, count: 1, id: "minecraft:potion"}
data modify storage main:item id.SPECTATOR_ABILITY_TELEPORT set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.spectator_ability","fallback":"Spectator Ability: %s","with":[{"color":"white","translate":"item.purple.spectator_ability.teleport","fallback":"Random Teleport"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.corrupted.0","fallback":"When Dead:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.spectator.0","fallback":"When in Spectator Mode:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.1","fallback":"Punch the air to"}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.2","fallback":"use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[30]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f, sound: "minecraft:intentionally_empty", has_consume_particles: 0b}, "minecraft:custom_data": {id: "SPECTATOR_ABILITY"}}, count: 1, id: "minecraft:ender_eye"}
data modify storage main:item id.SPECTATOR_ABILITY_SLIME set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.spectator_ability","fallback":"Spectator Ability: %s","with":[{"color":"white","translate":"item.purple.spectator_ability.slime","fallback":"Slime Swarm"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.corrupted.0","fallback":"When Dead:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.spectator.0","fallback":"When in Spectator Mode:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.1","fallback":"Punch the air to"}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.2","fallback":"use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[20]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "SPECTATOR_ABILITY"}}, count: 1, id: "minecraft:slime_ball"}
data modify storage main:item id.SPECTATOR_ABILITY_TIME set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.spectator_ability","fallback":"Spectator Ability: %s","with":[{"color":"white","translate":"item.purple.spectator_ability.time","fallback":"Reduce Timer"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.corrupted.0","fallback":"When Dead:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.spectator.0","fallback":"When in Spectator Mode:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.1","fallback":"Punch the air to"}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.2","fallback":"use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[60]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "SPECTATOR_ABILITY"}}, count: 1, id: "minecraft:clock"}
data modify storage main:item id.SPECTATOR_ABILITY_ITEM set value {components: {"minecraft:item_name": {"color":"green","translate":"item.purple.spectator_ability","fallback":"Spectator Ability: %s","with":[{"color":"white","translate":"item.purple.spectator_ability.item","fallback":"Item Box"}]}, "minecraft:lore": ["", {"color":"gray","italic":false,"translate":"item.modifiers.corrupted.0","fallback":"When Dead:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.1","fallback":"Right-Click %s","with":[[{"color":"#AA00AA","text":"T"},{"color":"#B317AE","text":"h"},{"color":"#BD2DB2","text":"e "},{"color":"#C644B5","text":"P"},{"color":"#D05BB9","text":"u"},{"color":"#D971BD","text":"r"},{"color":"#E388C1","text":"p"},{"color":"#EC9FC4","text":"l"},{"color":"#FFCCCC","text":"e"}]]}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.corrupted.2","fallback":"to use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.spectator.0","fallback":"When in Spectator Mode:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.1","fallback":"Punch the air to"}], [" ",{"color":"blue","italic":false,"translate":"item.modifiers.spectator.2","fallback":"use your ability!"}], "", {"color":"gray","italic":false,"translate":"item.modifiers.cooldown.0","fallback":"Cooldown:"}, [" ",{"color":"blue","italic":false,"translate":"item.modifiers.cooldown.1","fallback":"%s seconds","with":[10]}], ], "minecraft:max_stack_size": 1, "minecraft:rarity": "common", "minecraft:profile": {properties: [{name: "textures", value: "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmZkY2ZiNDAwOTc2YmY3M2VjMzJjMWI5OTYyYzgzMGZjM2Q3MDA2ZDc0OWY4ZjNkYTNiNmUwZmI4MjkwOWIyOCJ9fX0="}]}, "minecraft:consumable": {consume_seconds: 1000000.0f}, "minecraft:custom_data": {id: "SPECTATOR_ABILITY"}, "!minecraft:equippable": {}}, count: 1, id: "minecraft:player_head"}

# artifacts
data modify storage main:item id.ARTIFACT_TEST set value {components: {"minecraft:item_name": {"fallback":"Armor Stand","translate":"item.purple.artifact.test.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:max_stack_size": 1, "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_TEST"}}, count: 1, id: "minecraft:armor_stand"}
data modify storage main:item id.ARTIFACT_FRYING_PAN set value {components: {"minecraft:item_name": {"fallback":"Frying Pan","translate":"item.purple.artifact.frying_pan.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_FRYING_PAN"}, "minecraft:jukebox_playable": {song:"minecraft:strad"}, "minecraft:tooltip_display": {"hidden_components": ["minecraft:jukebox_playable"]}}, count: 1, id: "minecraft:music_disc_strad"}
data modify storage main:item id.ARTIFACT_MICROSCOPE set value {components: {"minecraft:item_name": {"fallback":"Microscope","translate":"item.purple.artifact.microscope.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_MICROSCOPE"}}, count: 1, id: "minecraft:spyglass"}
data modify storage main:item id.ARTIFACT_UGLY_FISH set value {components: {"minecraft:item_name": {"fallback":"Ugly Fish","translate":"item.purple.artifact.ugly_fish.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:max_stack_size": 1, "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_UGLY_FISH"}}, count: 1, id: "minecraft:pufferfish"}
data modify storage main:item id.ARTIFACT_POTTED_PLANT set value {components: {"minecraft:item_name": {"fallback":"Potted Specimen","translate":"item.purple.artifact.potted_plant.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:max_stack_size": 1, "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_POTTED_PLANT"}}, count: 1, id: "minecraft:flower_pot"}
data modify storage main:item id.ARTIFACT_ROPE set value {components: {"minecraft:item_name": {"fallback":"Spare Rope","translate":"item.purple.artifact.rope.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:max_stack_size": 1, "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_ROPE"}}, count: 1, id: "minecraft:lead"}
data modify storage main:item id.ARTIFACT_DRILL set value {components: {"minecraft:item_name": {"fallback":"Jackhammer","translate":"item.purple.artifact.drill.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:max_stack_size": 1, "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_DRILL"}}, count: 1, id: "minecraft:golden_carrot"}
data modify storage main:item id.ARTIFACT_METEORITE set value {components: {"minecraft:item_name": {"fallback":"Meteorite Chunk","translate":"item.purple.artifact.meteorite.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:max_stack_size": 1, "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_METEORITE"}}, count: 1, id: "minecraft:heavy_core"}
data modify storage main:item id.ARTIFACT_GEARS set value {components: {"minecraft:item_name": {"fallback":"Lost Gears","translate":"item.purple.artifact.gears.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:max_stack_size": 1, "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_GEARS"}}, count: 1, id: "minecraft:waxed_copper_trapdoor"}
data modify storage main:item id.ARTIFACT_LANTERN set value {components: {"minecraft:item_name": {"fallback":"Lantern","translate":"item.purple.artifact.lantern.name"}, "minecraft:lore": [{"color":"dark_gray","fallback":"Artifact","italic":false,"translate":"item.purple.artifact.lore"}], "minecraft:max_stack_size": 1, "minecraft:rarity": "uncommon", "minecraft:custom_data": {id: "ARTIFACT_LANTERN"}}, count: 1, id: "minecraft:lantern"}
